<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class FilterRecurring extends Model 
{

    protected $table = 'filters_recurring';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name');

    public function filters()
    {
        return $this->hasMany('App\Models\Filter', 'filter_recurring_id');
    }

    public function subFiltersRecurring()
    {
        return $this->hasMany('App\Models\SubFilterRecurring');
    }

    public function subAccounts()
    {
        return $this->belongsToMany('App\Models\SubAccount', 'filter_reccuring_sub_accounts');
    }

}